IF NOT EXISTS (SELECT * FROM SYS.TABLES WHERE NAME = 'EST_PED_VD_DEVOLVIDA')
BEGIN
	CREATE TABLE [dbo].[EST_PED_VD_DEVOLVIDA](
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[CD_PED_NOVO] [int] NOT NULL,
		[CD_PED_ANTIGO] [int] NOT NULL,
	 CONSTRAINT [PK_EST_PED_VD_DEVOLVIDA] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FILIAL] ASC,
		[CD_PED_NOVO] ASC,
		[CD_PED_ANTIGO] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
	) ON [PRIMARY]

END
GO

IF NOT EXISTS (SELECT * FROM SYS.DEFAULT_CONSTRAINTS WHERE NAME = 'DF_EST_PED_VD_DEVOLVIDA_CD_EMP')
BEGIN
	ALTER TABLE [dbo].[EST_PED_VD_DEVOLVIDA] ADD  CONSTRAINT [DF_EST_PED_VD_DEVOLVIDA_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]
END
GO

IF NOT EXISTS (SELECT * FROM SYS.DEFAULT_CONSTRAINTS WHERE NAME = 'DF_EST_PED_VD_DEVOLVIDA_CD_FILIAL')
BEGIN
	ALTER TABLE [dbo].[EST_PED_VD_DEVOLVIDA] ADD  CONSTRAINT [DF_EST_PED_VD_DEVOLVIDA_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]
END
GO

IF NOT EXISTS (SELECT * FROM SYS.DEFAULT_CONSTRAINTS WHERE NAME = 'DF_EST_PED_VD_DEVOLVIDA_CD_CTR')
BEGIN
	ALTER TABLE [dbo].[EST_PED_VD_DEVOLVIDA] ADD  CONSTRAINT [DF_EST_PED_VD_DEVOLVIDA_CD_CTR]  DEFAULT ((0)) FOR [CD_PED_NOVO]
END
GO

IF NOT EXISTS (SELECT * FROM SYS.DEFAULT_CONSTRAINTS WHERE NAME = 'DF_EST_PED_VD_DEVOLVIDA_CD_PED')
BEGIN
	ALTER TABLE [dbo].[EST_PED_VD_DEVOLVIDA] ADD  CONSTRAINT [DF_EST_PED_VD_DEVOLVIDA_CD_PED]  DEFAULT ((0)) FOR [CD_PED_ANTIGO]
END
GO

IF NOT EXISTS (SELECT * FROM SYS.foreign_keys WHERE NAME = 'FK_EST_PED_VD_DEVOLVIDA_EST_PED_VD')
BEGIN
	ALTER TABLE [dbo].[EST_PED_VD_DEVOLVIDA]  WITH CHECK ADD  CONSTRAINT [FK_EST_PED_VD_DEVOLVIDA_EST_PED_VD] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_PED_ANTIGO])
	REFERENCES [dbo].[EST_PED_VD] ([CD_EMP], [CD_FILIAL], [CD_PED])

	ALTER TABLE [dbo].[EST_PED_VD_DEVOLVIDA] CHECK CONSTRAINT [FK_EST_PED_VD_DEVOLVIDA_EST_PED_VD]
END
GO

IF NOT EXISTS (SELECT * FROM SYS.foreign_keys WHERE NAME = 'FK_EST_PED_VD_DEVOLVIDA_EST_PED_VD2')
BEGIN
	ALTER TABLE [dbo].[EST_PED_VD_DEVOLVIDA]  WITH CHECK ADD  CONSTRAINT [FK_EST_PED_VD_DEVOLVIDA_EST_PED_VD2] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_PED_NOVO])
	REFERENCES [dbo].[EST_PED_VD] ([CD_EMP], [CD_FILIAL], [CD_PED])

	ALTER TABLE [dbo].[EST_PED_VD_DEVOLVIDA] CHECK CONSTRAINT [FK_EST_PED_VD_DEVOLVIDA_EST_PED_VD2]
END
GO
